<?php 
/*
  Text(THaCAA) - Text (Telling Humans and Computers Apart Automatically)
    a way of telling if the submitter of a web form is human or a bot by 
    getting them to answer a simple random question in a similar vein to
    the systems developed by www.captcha.net (Carnegie Mellon university)
    but in an accessible way.
                   
  Copyright (C) 2006  Daniel G. Davies
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
  
  Daniel Davies can be contacted via the web form at 
  http://system-x.info/?pageid=10&menutree=34,35
*/


function textTHaCAA_initseed() {
  srand((double)microtime()*1000000);
  mt_srand((double)microtime()*1000000);
  $seed=(microtime()*1000000)+rand(0,1000000)+mt_rand(0,1000000);
  return($seed);
};

function textTHaCAA_remoteseed() {
  if (isset($_GET['textTHaCAA'])) {
    return ($_GET['textTHaCAA']);
  } else if (isset($_POST['textTHaCAA'])) {
    return ($_POST['textTHaCAA']);
  } else {
	  return 0;
  };
}
function textTHaCAA_sessioninit($remoteseed=0) {
  global $textTHaCAA_datalocation;

  if ($remoteseed==0) {
    $remoteseed=md5(textTHaCAA_initseed());
  };
  $localseed=textTHaCAA_initseed();
  
  $filename = $textTHaCAA_datalocation.'/THaCAAsessions/session'.$remoteseed.'.txt';
  if (!$handle = fopen($filename, 'w')) {
    echo 'Cannot open textTHaCAA session file '.$remoteseed;
    exit;
  } else {
      if (fwrite($handle, $localseed) === FALSE) {
      echo 'Cannot write to textTHaCAA session file '.$remoteseed;
      exit;
    }
    
    fclose($handle);
    $output['localseed']=$localseed;
    $output['remoteseed']=$remoteseed;
    return $output;
  };
};

function textTHaCAA_sessionget($remoteseed) {
  global $textTHaCAA_datalocation;
  if (file_exists($textTHaCAA_datalocation.'/THaCAAsessions/session'.$remoteseed.'.txt')) {
    return file_get_contents($textTHaCAA_datalocation.'/THaCAAsessions/session'.$remoteseed.'.txt');
  } else {
    return false;
  };
};

function textTHaCAA_session_deleteold() {
  global $textTHaCAA_datalocation;
  $THaCAAdir = dir($textTHaCAA_datalocation.'/THaCAAsessions/');
  while (false !== ($sessionfiles[] = $THaCAAdir->read()));
  $THaCAAdir->close();
  
  array_shift($sessionfiles);
  array_shift($sessionfiles);
  array_pop($sessionfiles);
  
  while (list($key, $val) = each($sessionfiles)) {
    if (file_exists($textTHaCAA_datalocation.'/THaCAAsessions/'.$val)) {
      if (time() > filemtime($textTHaCAA_datalocation.'/THaCAAsessions/'.$val)+(60*20)) {;
        @unlink($textTHaCAA_datalocation.'/THaCAAsessions/'.$val);
      };
    };

  };
};

function textTHaCAA_generate($seed){
  global $textTHaCAA_datalocation;
  $THaCAAdir = dir($textTHaCAA_datalocation.'/THaCAAthings/');
  while (false !== ($THaCAAfiles[] = $THaCAAdir->read()));
  $THaCAAdir->close();
  
  array_shift($THaCAAfiles);
  array_shift($THaCAAfiles);
  array_pop($THaCAAfiles);
  
  reset($THaCAAfiles);
  $thingscounter=0;
  while (list($dirkey, $dirval) = each($THaCAAfiles)) {
    $THaCAAfile=file($textTHaCAA_datalocation.'/THaCAAthings/'.$dirval);
    while (list($filekey, $fileval) = each($THaCAAfile)) {
      $THaCAAthings[trim(ucfirst(substr($dirval,0,-4))).str_pad($thingscounter,4,'0',STR_PAD_LEFT)]=trim($fileval);
      $thingscounter++;
    };
  };
  
  mt_srand($seed);
  srand(mt_rand(0,99999999999));
  
  $rand_keys = array_rand($THaCAAthings, 5);
  while (list($key, $val) = each($rand_keys)) {
    $selectedthings[]=$THaCAAthings[$val];
  };
  
  $output['things']=$selectedthings;
  $output['type']=substr($rand_keys[mt_rand(0,4)],0,-4);
  
  for ($i = 0; $i < 5; $i++) {
    if (substr($rand_keys[$i],0,-4)==$output['type']) {
      $output['matches'][$i]=true;
    } else {
      $output['matches'][$i]=false;
    };
  };
  
  return($output);
};



function textTHaCAA_ask() {

  $sessiondata=textTHaCAA_sessioninit(textTHaCAA_remoteseed());
  $answernames=sha1($sessiondata['localseed'].$sessiondata['remoteseed']);
  if (isset($sessiondata['localseed']) and $sessiondata['localseed']) {
    $textTHaCAA_info=textTHaCAA_generate($sessiondata['localseed']);?>
    <div class="textTHaCAA">

			<fieldset>
			<legend>Select all of the <?php echo $textTHaCAA_info['type'] ?> in the following list</legend>
      <input type="hidden" name="textTHaCAA" value="<?php echo $sessiondata['remoteseed']; ?>" />
<?php for ($i=0;$i<5; $i++) {
?>    <input id="textTHaCAA<?php echo substr($answernames,$i*4,4); ?>" name="textTHaCAA<?php echo substr($answernames,$i*4,4); ?>" type="checkbox" value="1" />
      <label for="textTHaCAA<?php echo substr($answernames,$i*4,4); ?>"><?php echo $textTHaCAA_info['things'][$i];?></label><br />
<?php };?>
</fieldset>
    </div>

    <?php
    
  };
};


function textTHaCAA_answer() {

  if ($remoteseed=textTHaCAA_remoteseed())
  {
    if ($seed=textTHaCAA_sessionget($remoteseed)) {
		} else {
			return -1;
		};
    $refreshsession=textTHaCAA_sessioninit($remoteseed);
  } else {
    if (isset($seed)){unset($seed);};
  };
  if (isset($seed) and $seed) {
    $textTHaCAA_info=textTHaCAA_generate($seed);
    $answernames=sha1($seed.$remoteseed);
    
    $successcount=0;
    for ($i=0; $i<5; $i++) {
      if (
            $textTHaCAA_info['matches'][$i] 
            and (
              (
                isset($_GET['textTHaCAA'.substr($answernames,$i*4,4)]) 
                and $_GET['textTHaCAA'.substr($answernames,$i*4,4)]
              ) or (
                isset($_POST['textTHaCAA'.substr($answernames,$i*4,4)]) 
                and $_POST['textTHaCAA'.substr($answernames,$i*4,4)]
              )              
            )
          )
          {
        $successcount++;
      } else if (
                  !$textTHaCAA_info['matches'][$i] 
                  and (
                    (
                      !isset($_GET['textTHaCAA'.substr($answernames,$i*4,4)])
                    ) and (
                      !isset($_POST['textTHaCAA'.substr($answernames,$i*4,4)])
                    )
                  )
                )
      { 
        $successcount++;
      } else {
        $successcount=$successcount-10;
      };
    };
  };
  if (isset($successcount) and ($successcount==5)) {
    return 1;
  } else {
    return 0;
  };
};

function textTHaCAA_hasrun() {
  return isset($_GET['textTHaCAA']) or isset($_POST['textTHaCAA']) ;
};

textTHaCAA_session_deleteold();
?>